package com.genesyslab.mobile.android.sample;

import android.app.ActionBar;
import android.app.ActionBar.Tab;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.os.Bundle;
import android.support.v13.app.FragmentPagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.Menu;
import android.view.MenuInflater;

import com.genesyslab.mobile.android.sample.R;

public abstract class AbstractTabActivity extends AbstractGenesysActivity {
	
	protected static class TabElement {
		public final String text;
		public final Fragment fragment;
		public final int icon;
		public final Integer menuRes;
		
		public TabElement(String text, Fragment fragment, int icon, Integer menuRes) {
			this.text = text;
			this.fragment = fragment;
			this.icon = icon;
			this.menuRes = menuRes;
		}
	}
	
	protected final TabElement[] tabs;
	private TabFragmentPagerAdapter pagerAdapter;
    private ViewPager viewPager;
    private TabElement currentTab;

	protected AbstractTabActivity(TabElement[] tabs) {
		this.tabs = tabs;
	}
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
        setContentView(R.layout.main_layout);

        pagerAdapter = new TabFragmentPagerAdapter(getFragmentManager());
        viewPager = (ViewPager) findViewById(R.id.pager);
        viewPager.setOnPageChangeListener(
                new ViewPager.SimpleOnPageChangeListener() {
                    @Override
                    public void onPageSelected(int position) {
                        getActionBar().setSelectedNavigationItem(position);
                    }
                });

        viewPager.setAdapter(pagerAdapter);
        
        final ActionBar actionBar = getActionBar();
        actionBar.setNavigationMode(ActionBar.NAVIGATION_MODE_TABS);
        ActionBar.TabListener tabListener = new ActionBar.TabListener() {
			@Override
			public void onTabReselected(Tab arg0, FragmentTransaction arg1) {
			}

			@Override
			public void onTabSelected(Tab tab, FragmentTransaction t) {
				viewPager.setCurrentItem(tab.getPosition());
				currentTab = tabs[tab.getPosition()];
				invalidateOptionsMenu();
			}

			@Override
			public void onTabUnselected(Tab arg0, FragmentTransaction arg1) {
			}
        };
        
        for (int i = 0; i < tabs.length; i++) {
            actionBar.addTab(
            		actionBar.newTab()
                            .setText(tabs[i].text)
                            .setIcon(tabs[i].icon)
                            .setTabListener(tabListener));
        }
	}
	
	private class TabFragmentPagerAdapter extends FragmentPagerAdapter {

		public TabFragmentPagerAdapter(FragmentManager fm) {
			super(fm);
		}

		@Override
		public Fragment getItem(int i) {
			return tabs[i].fragment;
		}

		@Override
		public int getCount() {
			return tabs.length;
		}
		
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		super.onCreateOptionsMenu(menu);
	    MenuInflater inflater = getMenuInflater();
	    if (currentTab.menuRes != null)
	    	inflater.inflate(currentTab.menuRes.intValue(), menu);
	    return true;
	}

}
